function CMqReportViewer()
{

	//viewer type can be either 1, 2 or 3
	//1 will use the activeX report for IE and Java for firefox
	//2 is default which it will use the frame viewer
	//3 will use the html viewer
	var ACTIVEXJAVAVIEWER = 1;
	var FRAMEVIEWER = 2;
	var HTMLVIEWER = 3;

	var m_blnCREnabled=false;
	var m_lngViewerType = FRAMEVIEWER;

	var PLACEHOLDER_REC_ID = '$itemid$';
	var DO_NOT_SHOW_PARAMS_DIALOG = "&prmsapplied=1";
	
	function setViewerType(lngViewerType)
	{
		if (lngViewerType)
		{
			m_lngViewerType = lngViewerType;
		}
	}

	function OpenReport(lngReportID, blnPortrait, strViewerType, strAddSQL, 
						strWebReportASPPath, objRequest, strCurrentLocation, lngFeatureID, strAddWinProps, strAddQS, objContainer, strParams)
	{
		var PORTRAIT_LAYOUT = "portrait";
		var LANDSCAPE_LAYOUT = "landscape";
		
		var strWindowProperties="";
		var strOrientation;
		
		if(blnPortrait){
			strOrientation=PORTRAIT_LAYOUT;
		}else{
			strOrientation=LANDSCAPE_LAYOUT;
		}
		
		if (!strViewerType){
			if (m_lngViewerType == FRAMEVIEWER)
			{
				strViewerType="HTML Frame";
			}
			else if (m_lngViewerType == HTMLVIEWER)
			{
				strViewerType="HTML Page";
			}
			else{
				if (g_MqRef.MqBrowser.ie){
					strViewerType="ActiveX";
				}else{
					strViewerType="Java%20Applet";
				}
			}
		}
		
		if(m_blnCREnabled==null){
			if (objRequest){
				var strUrlPath=strCurrentLocation + strWebReportASPPath + "?WCI=IsCREnabled&";
						
				m_blnCREnabled=parseInt(objRequest.Get(strUrlPath));
			}	
		}
			
		if(m_blnCREnabled){
			strWindowProperties="toolbar=no,directories=no,resizable=yes,scrollbars=yes,";
		}else{
			strWindowProperties="menubar=yes,toolbar=yes,directories=no,resizable=yes,scrollbars=yes,";
		}
		if (strAddWinProps){
			strWindowProperties+=strAddWinProps;
		}
		var strQueryString="LayoutType=" + strOrientation +"&ViewerType=" + strViewerType + "&ReportKey=" + lngReportID + "&FeatureID=" + lngFeatureID + "&rd=" + Math.floor(Math.random()*1000001);
		
		if(strAddQS){
			strQueryString+=strAddQS;
		}
		
		if(strAddSQL){
			strQueryString+="&AddSQL=" + strAddSQL;
		}
	
		if(!strParams){
			strParams = GetReportParameters(lngReportID);
		}	
		if(strParams){
			strQueryString+=strParams;
		}
	
		if(objContainer){
			objContainer.src=strWebReportASPPath + "?WCI=ViewReport&" + strQueryString;
		}else{
			window.open(strWebReportASPPath + "?WCI=ViewReport&" + strQueryString,"",strWindowProperties);
		}	
	}
	
	function GetCREnabled()
	{
		return m_blnCREnabled;
	}
	
	function SetCREnabled(blnCREnabled)
	{
		m_blnCREnabled=blnCREnabled;
	}
	
	function WriteActiveXViewer()
	{
		var strHTML="<object classid='CLSID:C4847596-972C-11D0-9567-00A0C9273C2A' " +
			"codebase='viewer/activeXViewer/activexviewer.cab#Version=8,0,0,224' " +
			"height='100%' id='CRViewer' width='100%'>" +
			"	<PARAM NAME='DisplayGroupTree' VALUE='0'>" +
			"	<PARAM NAME='EnableGroupTree' VALUE='0'>" +
			"	<PARAM NAME='EnablePrintButton' VALUE='-1'>" +
			"	<PARAM NAME='EnableZoomControl' VALUE='-1'>" +
			"	<PARAM NAME='EnableCloseButton' VALUE='-1'>" +
			"	<PARAM NAME='EnableSearchControl' VALUE='-1'>" +
			"	<PARAM NAME='EnableRefreshButton' VALUE='0'>" +
			"	<PARAM NAME='EnableDrillDown' VALUE='-1'>" +
			"	<PARAM NAME='EnableAnimationControl' VALUE='0'>" +
			"	<PARAM NAME='DisplayBorder' VALUE='-1'>" +
			"	<PARAM NAME='DisplayTabs' VALUE='0'>" +
			"	<PARAM NAME='SelectionFormula' VALUE='0'>" +
			"	<PARAM NAME='EnablePopupMenu' VALUE='-1'>" +
			"	<PARAM NAME='EnableExportButton' VALUE='-1'>" +
			"	<PARAM NAME='ZoomWindow' VALUE='1'>" +
			"</object>";
			
			document.write(strHTML);
	}
	
	function WriteActiveX9Viewer()
	{
		var strHTML="<object classid='CLSID:2DEF4530-8CE6-41c9-84B6-A54536C90213' " + 
			"codebase='viewer9/activeXViewer/activexviewer.cab#Version=9,2,0,442' " + 
			"height='100%' id='CRViewer' width='100%'>" + 
			"	<PARAM NAME='DisplayGroupTree' VALUE='0'>" + 
			"	<PARAM NAME='EnableGroupTree' VALUE='0'>" + 
			"	<PARAM NAME='EnablePrintButton' VALUE='-1'>" +
			"	<PARAM NAME='EnableZoomControl' VALUE='-1'>" +
			"	<PARAM NAME='EnableCloseButton' VALUE='-1'>" +
			"	<PARAM NAME='EnableSearchControl' VALUE='-1'>" +
			"	<PARAM NAME='EnableRefreshButton' VALUE='0'>" +
			"	<PARAM NAME='EnableDrillDown' VALUE='-1'>" +
			"	<PARAM NAME='EnableAnimationControl' VALUE='0'>" +
			"	<PARAM NAME='DisplayBorder' VALUE='-1'>" +
			"	<PARAM NAME='DisplayTabs' VALUE='0'>" +
			"	<PARAM NAME='SelectionFormula' VALUE='0'>" +
			"	<PARAM NAME='EnablePopupMenu' VALUE='-1'>" +
			"	<PARAM NAME='EnableExportButton' VALUE='-1'>" +
			"	<PARAM NAME='ZoomWindow' VALUE='1'>" +
			"</object>";

			document.write(strHTML);
	}
	
	function WriteJavaViewer()
	{
		var strLocation=document.location.toString();

		var intLastSlashPosition=strLocation.lastIndexOf("/");

		var strCodeBase;

		strCodeBase=strLocation.substr(0,intLastSlashPosition);

		strCodeBase+= "/viewer/JavaViewer";

		if(_ns3==true){
			document.writeln( '<applet code=com.seagatesoftware.img.ReportViewer.ReportViewer codebase="'
							+ strCodeBase +
							'" id=ReportViewer width=100% height=100% archive="'
							+ strCodeBase +
							'/ReportViewer.zip">' );
		}else if (_ns4plus == true){
			document.writeln( '<applet code=com.seagatesoftware.img.ReportViewer.ReportViewer codebase="'
							+ strCodeBase +
							'" id=ReportViewer width=100% height=100% archive="'
							+ strCodeBase +
							'/ReportViewer.jar">' );
		}else{
			document.writeln( '<applet code=com.seagatesoftware.img.ReportViewer.ReportViewer codebase="'
							+ strCodeBase +
							'" id=ReportViewer width=100% height=100%  >' );
		}

		document.writeln(
			'<param name=ReportName value="viewer/Web Component Server/rptserver.asp">' +
			'<param name=HasGroupTree value="false">' +
			'<param name=ShowGroupTree value="false">'  +
			'<param name=HasRefreshButton value="false">'  +
			'<param name=canDrillDown value="true">' +
			'<param name=HasPrintButton value=true>' +
			'<param name=HasExportButton value=true>' +
			'<param name=zoomFactor value="1">' +
			'<param name=cabbase value="' + strCodeBase + '/ReportViewer.cab">');
	}
	
	function WriteJava9Viewer()
	{
		var strLocation=document.location.toString();

		var intLastSlashPosition=strLocation.lastIndexOf("/");

		var strCodeBase;

		strCodeBase=strLocation.substr(0,intLastSlashPosition);

		strCodeBase+= "/viewer9/JavaViewer";

		if(_ns3==true){
			document.writeln( '<applet code=com.crystaldecisions.ReportViewer.ReportViewer codebase="'
							+ strCodeBase +
							'" id=ReportViewer width=100% height=100% archive="'
							+ strCodeBase +
							'/ReportViewer.zip">' );
		}else if (_ns4plus == true){
			document.writeln( '<applet code=com.crystaldecisions.ReportViewer.ReportViewer codebase="'
							+ strCodeBase +
							'" id=ReportViewer width=100% height=100% archive="'
							+ strCodeBase +
							'/ReportViewer.jar">' );
		}else{
			document.writeln( '<applet code=com.crystaldecisions.ReportViewer.ReportViewer codebase="'
							+ strCodeBase +
							'" id=ReportViewer width=100% height=100%  >' );
		}

		document.writeln(
			'<param name=ReportName value="viewer9/Web Component Server/rptserver.asp">' +
			'<param name=HasGroupTree value="false">' +
			'<param name=ShowGroupTree value="false">'  +
			'<param name=HasRefreshButton value="false">'  +
			'<param name=canDrillDown value="true">' +
			'<param name=HasPrintButton value=true>' +
			'<param name=HasExportButton value=true>' +
			'<param name=zoomFactor value="1">' +
			'<param name=cabbase value="' + strCodeBase + '/ReportViewer.cab">');
	}
	
	this.OpenReport=OpenReport;
	this.GetCREnabled=GetCREnabled;
	this.SetCREnabled=SetCREnabled;
	this.WriteActiveXViewer=WriteActiveXViewer;
	this.WriteActiveX9Viewer=WriteActiveX9Viewer;
	this.WriteJavaViewer=WriteJavaViewer;
	this.WriteJava9Viewer=WriteJava9Viewer;
	this.ViewReportByID=ViewReportByID;
	this.ViewReport=ViewReport;
	this.GetReportParameters=GetReportParameters;
	this.setViewerType=setViewerType;
	this.ACTIVEXJAVAVIEWER=ACTIVEXJAVAVIEWER;
	this.FRAMEVIEWER=FRAMEVIEWER;
	this.HTMLVIEWER=HTMLVIEWER;

	function GetReportParameters(strReportNumber, lngItemID){
	    var strParams = '';
	    var MSG_INCLUDE_REPORT_FILE_NOT_FOUND = 'The file Reports.js was not found in the web view.';
		
	    if(typeof(MqReports) != 'undefined'){
	    	try{
			    for(var c=0;c<MqReports.length;c++){		    
				 	if(MqReports[c][REPORT_NUMBER] == strReportNumber){
					 	strParams = MqReports[c][REPORT_PARAMETER];
					 	break;	
				 	}
			    }		
			
				if(strParams!=""){
					if(!lngItemID){
						lngItemID = GetCurrentRecID();
					}
					strParams = strParams.replace(PLACEHOLDER_REC_ID,lngItemID + DO_NOT_SHOW_PARAMS_DIALOG);
				}
		   	}
		   	
		   	catch(e){
				g_MqRef.MsgHlpr.DisplayMessage(MSG_INCLUDE_REPORT_FILE_NOT_FOUND + '\r' + e);
				return false;
			}
		}	
		
	    return strParams;
    }
    
	function GetCurrentRecID()
	{
		var lngRecID=0;
		if(document.objRecord){
			lngRecID = document.objRecord.GetRecordId();
		}else{
			if(parent.objRecord){
				lngRecID = parent.objRecord.GetRecordId();
			}
		}
		return lngRecID;
	}
    function ViewReportByID(ReportNumber, pLngItemID)
	{		
		
		var ItemID;
		var objRef=document;
		var strAddSQL="";

		if(typeof(pLngItemID) == 'undefined'){
			ItemID = GetCurrentRecID();
		}else{
			ItemID = pLngItemID;
		}

		var strReportWASPPath="../../Reports/WCMqWebReport.ASP";
		var blnPrevCREn=this.GetCREnabled();
		
		var strParams = GetReportParameters(ReportNumber, ItemID);
		
		strParams = strParams.replace(PLACEHOLDER_REC_ID,ItemID + DO_NOT_SHOW_PARAMS_DIALOG);
					
		this.SetCREnabled(true);
		
		if (ItemID > 0){			
			strAddSQL="[tblUser.nID][=]" + ItemID;
		}
		this.OpenReport(ReportNumber, true, '', strAddSQL, 
		strReportWASPPath,objRequest, objRef.mstrCurrentLocation,17,null,"", null, strParams);

		this.SetCREnabled(blnPrevCREn);
	}	
	
	function ViewReport(strReportID, lngRecordId){
		var objRef = this;
		setTimeout(function(){objRef.ViewReportByID(strReportID, lngRecordId)},300);
	}
	
}